define(['angular', 'app'], function(angular, app) {
	app.constant("HomePageConstants",
		{
			"weekly-goals" : {
				activeFlag : true,
				startDate : '03/01/2019',
				endDate : '03/08/2019',
				target : {
					minutes : 0,
					steps: 0,
					miles : 0
				},
				progress : {
					minutes : 0,
					steps: 0,
					miles : 0
				},
				extensions : {
					object : {
						dateKey : 'startDate',
						defaults : {
							activeFlag : true,
							startDate : '03/01/2019',
							target : {
								minutes : 100,
								steps: 100,
								miles : 100
							}
						}
					},
					dependency: {
						linkTitles : {
							GET : 'goals',
							POST : 'goals'
						}
					},
					collection : {
						name : 'fitness-goals',
						objectType : 'FitnessGoals'
					}
				}
			}
		},
		{
			'goals' : {
				extensions : {
					object : {
						dateKey : 'effectiveDateTime',
						defaults : {
							activeFlag : true,
							startDate : '03/01/2019',
							target : {
								minutes : 100,
								steps: 100,
								miles : 100
							}
						}
					},
					dependency: {
						linkTitles : {
							GET : 'goals',
							POST : 'goals'
						}
					},
					collection : {
						name : 'fitness-goals',
						objectType : 'FitnessGoals'
					}
				}
			}
		}
	);
});

